
(function (window, document) {
	window.SuChatAPI = {
		init: (config) => {
			if (!config.chatCode) {
				alert('Empty SuChat chatCode');
				return;
			}
			if (!config.target) {
				alert('Empty SuChat target');
				return;
			}

			if (!config.id) {
				config.id = Math.random().toString().split('.')[1];
			}
			window.SuChatAPI._loadResources(config);
			window.SuChatAPI._renderChat(config);
			console.log('SuChatAPI initialized');
		},
		_renderChat: (config) => {

			const chatEl = document.createElement('su-chat');
			chatEl.id = 'su-chat-' + config.id;
			chatEl.initialConfig = config;
			document.body.appendChild(chatEl);

			console.log('SuChat rendered');
		},
		_loadResources: (config) => {
			const target = config.target || '';

			if (true) { // TEMP
				const fontLink = document.createElement('link');
				fontLink.rel = 'stylesheet';
				fontLink.href = 'https://fonts.googleapis.com/icon?family=Material+Icons';
				document.head.appendChild(fontLink);
			}

			const link = document.createElement('link');
			link.rel = 'stylesheet';
			link.href = target + '/assets/css/su-chat-widget.css';
			document.head.appendChild(link);

			const polyfillsScript = document.createElement('script');
			polyfillsScript.src = target + '/assets/js/polyfills.js';
			document.body.appendChild(polyfillsScript);

			const script = document.createElement('script');
			script.src = target + '/assets/js/su-chat-widget.js';
			document.body.appendChild(script);
		}
	};
})(window, document);
